
#################################################################
#### PLOTS#########################################
################################################################

library(ggplot2)
library(bayesplot)
library(dplyr)
library(reshape2)


### Figura 1: shin/basic probabilities
## (Section 2)

#carico PL
load("ShinProbabilitiesPL.RData")
p_shin_PL =p_shin


comparison_plot <- function(p_shin, p_norm){
p_norm_aggr=apply(p_norm,c(1,3), mean)
p_shin_aggr=apply(p_shin,c(1,3), mean)

#log-odds

log_odds_home <- log(sum(as.vector(p_norm_PL[,,1]) )/
    sum(as.vector(p_shin_PL[,,1])))
log_odds_draw <- log(sum(as.vector(p_norm_PL[,,2]) )/
    sum(as.vector(p_shin_PL[,,2])))
log_odds_loss <- log(sum(as.vector(p_norm_PL[,,3]) )/
    sum(as.vector(p_shin_PL[,,3])))

log_odds <- c(log_odds_home, log_odds_draw, log_odds_loss)

#correlations

home_corr <- cor(as.vector(p_norm_PL[,,1]), 
  as.vector(p_shin_PL[,,1]))
draw_corr <- cor(as.vector(p_norm_PL[,,2]), 
  as.vector(p_shin_PL[,,2]))
loss_corr <- cor(as.vector(p_norm_PL[,,3]), 
  as.vector(p_shin_PL[,,3]))

corrs <- c(home_corr, draw_corr, loss_corr)

##ggplot version

ggplot()+
  geom_point(aes(x=p_shin_aggr[,1], y=p_norm_aggr[,1]),
    color = color_scheme_get("red")[[4]])+
  geom_abline(slope=1,intercept=0)+
  labs(x="Shin probabilities", y="Basic probabilities")+
  lims(x=c(0,1), y=c(0,1))+
  xaxis_text(size=1.2)+
  yaxis_text(size=1.2)
ggsave("ComparingProbWin.pdf", width=6, height=4)

ggplot()+
  geom_point(aes(x=p_shin_aggr[,2], y=p_norm_aggr[,2]),
    color = color_scheme_get("yellow")[[4]])+
  geom_abline(slope=1,intercept=0)+
  labs(x="Shin probabilities", y="Basic probabilities")+
  lims(x=c(0,0.4), y=c(0,0.4))+
  xaxis_text(size=1.2)+
  yaxis_text(size=1.2)
ggsave("ComparingProbDraw.pdf", width=6, height=4)

ggplot()+
  geom_point(aes(x=p_shin_aggr[,3], y=p_norm_aggr[,3]),
    color = color_scheme_get("blue")[[4]])+
  geom_abline(slope=1,intercept=0)+
  labs(x="Shin probabilities", y="Basic probabilities")+
  lims(x=c(0,1), y=c(0,1))+
  xaxis_text(size=1.2)+
  yaxis_text(size=1.2)
ggsave("ComparingProbAway.pdf", width=6, height=4)

return(list(corrs=corrs, log_odds=log_odds))
}

PL_prob_comp <- comparison_plot(p_shin_PL,p_norm_PL )

#### Figure 2:  Attack/Defense effects   ###
### (Section 4.2)

attack_defence_plots=function(string, league, fattori_att, fattori_def, nteams,teams, T, squadre16_17){


season_unique=1:T

att_med=apply(fattori_att,2, median)
def_med=apply(fattori_def,2, median)
att_25=apply(fattori_att, 2, function(x) quantile(x, 0.25))
att_75=apply(fattori_att, 2, function(x)  quantile(x, 0.75))
def_25=apply(fattori_def, 2, function(x) quantile(x, 0.25))
def_75=apply(fattori_def, 2, function(x)  quantile(x, 0.75))

att_25_mat=att_75_mat=def_25_mat=def_75_mat=att_50_mat=def_50_mat=matrix(NA, nteams, T)
for (t in 1:T){
  att_25_mat[,t]=as.vector(att_25[  (t*nteams-((nteams-1))):(t*nteams)])
  att_50_mat[,t]=as.vector(att_med[  (t*nteams-((nteams-1))):(t*nteams)])
  att_75_mat[,t]=as.vector(att_75[  (t*nteams-((nteams-1))):(t*nteams)])
  def_25_mat[,t]=as.vector(def_25[  (t*nteams-((nteams-1))):(t*nteams)])
  def_50_mat[,t]=as.vector(def_med[  (t*nteams-((nteams-1))):(t*nteams)])  
  def_75_mat[,t]=as.vector(def_75[  (t*nteams-((nteams-1))):(t*nteams)])
}

team16_17=match(squadre16_17, teams)

att_25_mat=att_25_mat[team16_17,]
att_50_mat=att_50_mat[team16_17,]
att_75_mat=att_75_mat[team16_17,]
def_25_mat=def_25_mat[team16_17,]
def_50_mat=def_50_mat[team16_17,]
def_75_mat=def_75_mat[team16_17,]



mt_att_25=melt(att_25_mat)
mt_att_50=melt(att_50_mat)
mt_att_75=melt(att_75_mat)

mt_def_25=melt(def_25_mat)
mt_def_50=melt(def_50_mat)
mt_def_75=melt(def_75_mat)

teams_fac_rep=rep(squadre16_17, 10)
season_rep=rep(1:10, each=length(squadre16_17))

att_data=data.frame(
  teams=teams_fac_rep,
  season=season_rep,
  mid=mt_att_50$value,
  lo=mt_att_25$value,
  hi=mt_att_75$value
)

def_data=data.frame(
  teams=teams_fac_rep,
  season=season_rep,
  mid=mt_def_50$value,
  lo=mt_def_25$value,
  hi=mt_def_75$value
)



position_lookup <-
  att_data %>%
  group_by(teams) %>%
  summarise(pos=first(teams))

label_w_position <- function(team_name) {
  paste0(team_name, " (", with(position_lookup, pos[teams == player_name]),")")
}

ggplot() + 
  geom_ribbon(
    aes(x = season, ymin = lo, ymax = hi), 
    data = att_data,
    fill = color_scheme_get("gray")[[2]]
  ) +
  geom_ribbon(
    aes(x = season, ymin = lo, ymax = hi), 
    data = def_data,
    fill = color_scheme_get("gray")[[2]]
  )+
  geom_line(
    aes(x = season, y = mid), 
    data = att_data,
    size = 1,
    color = color_scheme_get("red")[[4]]
  )+ 
  geom_line(
    aes(x = season, y = mid), 
    data = def_data,
    size = 1,
    color = color_scheme_get("blue")[[4]]
  )+
  scale_color_manual(values = c(color_scheme_get("blue")[[4]], 
                                color_scheme_get("red")[[4]]))+ 
  facet_wrap("teams", scales = "free")+ 
  lims(y = c(-0.8, 0.8)) + 
  scale_x_discrete( limits=c("07/08","","","", "11/12","", "","","", "16/17")  ) + 
  labs(x = "Seasons", y = "Teams' effects", 
       title = "Attack and defense effects (50% posterior bars)", 
       subtitle = "for teams of Premier League 2016/2017") +
        xaxis_text( size = rel(0.7)) 


#return(att_data)
}

  #save jpeg directly from R window (width= 690; height= 512)
  # (intervals for ylim: c(-0.6, 0.6) for all the leagues, except for Liga (-0.6,1) and Bundes (-0.8, 0.8))

  attack_defence_plots("Ita", serieA, fattori_att_serieA, fattori_def_serieA, nteams_serieA,teams_serieA,T, squadre16_17_serieA)

  attack_defence_plots("Eng", PL, fattori_att_PL, fattori_def_PL,
    nteams_PL, teams_PL,T,  squadre16_17_PL)
 # ggsave("TeamEffects16-17PL.pdf", height=10, width =10)

  attack_defence_plots("Spa", Liga, fattori_att_Liga, fattori_def_Liga, nteams_Liga, teams_Liga,T, squadre16_17_Liga)

attack_defence_plots("Ger",BundesLiga,fattori_att_BundesLiga, fattori_def_BundesLiga, nteams_BundesLiga, teams_BundesLiga,T, squadre16_17_BundesLiga)
  
  
## Figura 3: p
## (Section 4.3)
  p_plot <-function(league, pClust1, 
    #pClust2, 
    ngames_train){
  
  p1_median=apply(pClust1[,1:ngames_train],2, median)
  p1_2_5=apply(pClust1[,1:ngames_train],2, function(x) quantile(x, 0.025))
  p1_2_5_order=sort(p1_2_5)
  p1_25=apply(pClust1[,1:ngames_train],2, function(x) quantile(x, 0.25))
  p1_25_order=sort(p1_25)
  p1_975=apply(pClust1[,1:ngames_train],2, function(x) quantile(x, 0.975))
  p1_975_order=sort(p1_975)
  p1_75=apply(pClust1[,1:ngames_train],2, function(x) quantile(x, 0.75))
  p1_75_order=sort(p1_75)
  
  p1_median_order=sort(p1_median)
  
  
  p1_data=data.frame(
    ngames_train=1:ngames_train,
    p1_25_order=p1_25_order,
    p1_75_order=p1_75_order,
    p1_2_5_order=p1_2_5_order,
    p1_975_order=p1_975_order,
    p1_median_order=p1_median_order
  )
  
  ggplot()+
    geom_ribbon(
      aes(x = ngames_train, ymin = p1_25_order, ymax = p1_75_order), 
      data = p1_data,
      fill = color_scheme_get("gray")[[2]]
    )+
    geom_line(aes(x=ngames_train, y=p1_median_order),
      data=p1_data,
      col="red")+
    labs(x="Games", y="p",
      title = "Mixing parameter (50% posterior bars)")+
    xaxis_text( size = rel(1))+
    yaxis_text( size = rel(1))+
    theme(plot.title = element_text(size = 15))
  
  #setwd("../Review/Images_paper")
  ggsave(file=paste("p1", league,".pdf",sep=""), height=6, width=6)
  }
  
  p_plot("Ger", pClust1_BundesLiga,  ngames_train_BundesLiga)
  
  p_plot("Eng", pClust1_PL,  ngames_train_PL)
  
  p_plot("Ita", pClust1_serieA,  ngames_train_serieA)
  
  p_plot("Spa", pClust1_Liga,  ngames_train_Liga)
  



#### Figure 4: Posterior predictive distributions ###
## (Section 4.3)
  
replicated_data <- function(league, M, ngames_train, theta1_hat, theta2_hat){  
  
  y_rep1=matrix(NA, M,ngames_train )
  y_rep2=matrix(NA, M,ngames_train )
  
  
  for (s in 1:M){
    for (n in 1:ngames_train){
      y_rep1[s,n]=rpois(1, theta1_hat[s,n])
      y_rep2[s,n]=rpois(1, theta2_hat[s,n])
    }
  }
  
 save(y_rep1, y_rep2, file=paste("y_rep2", league,".RData", sep="")) 
}

pp_check_function <- function(league, y_rep1, y_rep2, ngames_train, theta1_hat, theta2_hat,score1, score2, M){
  
  
  
  diff_gol=score1-score2
  diff_gol_rep=y_rep1-y_rep2
  
  #boxplots
  
  esiti_short=seq(-3,3,1)
  freq_rel_matrix=matrix(NA, M, length(esiti_short))
  
  for (j in 1:M){
    for (u in 1:length(esiti_short)){
      freq_rel_matrix[j,u]=  (as.double(table(diff_gol_rep[j,]))[as.double(names(table(diff_gol_rep[j,])))==esiti_short[u]])/ngames_train
    }}
  
  
  freq_rel_frame_add=matrix(NA, M*length(esiti_short),2)
  for(j in 1:M){
    freq_rel_frame=data.frame(valori=esiti_short,  rel=freq_rel_matrix[j,])
    freq_rel_frame_add[( (7*j)-6):(7*j),]=as.matrix(freq_rel_frame)
  }
  
  
  freq_rel_obs=c()
  for (u in 1:length(esiti_short)){
    freq_rel_obs[u]=(as.double(table(diff_gol))[ as.double(names(table(diff_gol)))==esiti_short[u]])/ngames_train
    
  }
  
  frame=data.frame(valori=esiti_short, rel=freq_rel_frame_add[,2] )
  
  ggplot(frame, aes(x=valori, y=rel))+
    geom_point(position = "jitter", alpha = 0.2, col="gray") +
    geom_segment(mapping=aes( x=-3-0.5, y=freq_rel_obs[1],
      xend=-3+0.5, yend=freq_rel_obs[1]) , size=2, color = "blue")+
    geom_segment(mapping=aes( x=-2-0.5, y=freq_rel_obs[2],
      xend=-2+0.5, yend=freq_rel_obs[2]) , size=2, color = "blue")+
    geom_segment(mapping=aes( x=-1-0.5, y=freq_rel_obs[3],
      xend=-1+0.5, yend=freq_rel_obs[3]) , size=2, color = "blue")+
    geom_segment(mapping=aes( x=0-0.5, y=freq_rel_obs[4],
      xend=0+0.5, yend=freq_rel_obs[4]) , size=2, color = "blue")+
    geom_segment(mapping=aes( x=1-0.5, y=freq_rel_obs[5],
      xend=1+0.5, yend=freq_rel_obs[5]) , size=2, color = "blue")+
    geom_segment(mapping=aes( x=2-0.5, y=freq_rel_obs[6],
      xend=2+0.5, yend=freq_rel_obs[6]) , size=2, color = "blue")+
    geom_segment(mapping=aes( x=3-0.5, y=freq_rel_obs[7],
      xend=3+0.5, yend=freq_rel_obs[7]) , size=2, color = "blue")+
    labs(x="Goal difference", y="Posterior probabilities")+
    scale_x_discrete(limits=esiti_short, labels=c("-3", "-2", "-1", "0","1", "2", "3"))
  
}


#save jpeg directly from window ()
#replicated_data("Ita", M=M, ngames_train=ngames_train_serieA,
 # theta1_hat=theta1_hat_serieA, theta2_hat=theta2_hat_serieA)
load("y_rep2Ita.RData")
pp_check_function("Ita",y_rep1=y_rep1, y_rep2=y_rep2,
  ngames_train=ngames_train_serieA, 
  theta1_hat=theta1_hat_serieA, theta2_hat=theta2_hat_serieA,
  score1=score1_serieA, score2=score2_serieA, M=M)


#replicated_data("Eng", M=M, ngames_train=ngames_train_PL,
 # theta1_hat=theta1_hat_PL, theta2_hat=theta2_hat_PL)
load("y_rep2Eng.RData")
pp_check_function("Eng", y_rep1=y_rep1, y_rep2=y_rep2,  
  ngames_train=ngames_train_PL, 
  theta1_hat=theta1_hat_PL, theta2_hat=theta2_hat_PL,
  score1=score1_PL, score2=score2_PL, M=M)


#replicated_data("Spa", M=M, ngames_train=ngames_train_Liga,
 # theta1_hat=theta1_hat_Liga, theta2_hat=theta2_hat_Liga)
load("y_rep2Spa.RData")
pp_check_function("Spa", y_rep1=y_rep1, y_rep2=y_rep2,
  ngames_train=ngames_train_Liga, 
  theta1_hat=theta1_hat_Liga, theta2_hat=theta2_hat_Liga,
  score1=score1_Liga, score2=score2_Liga, M=M)


#replicated_data("Ger", M=M, ngames_train=ngames_train_BundesLiga,
 # theta1_hat=theta1_hat_BundesLiga, theta2_hat=theta2_hat_BundesLiga)
load("y_rep2Ger.RData")
pp_check_function("Ger", y_rep1=y_rep1, y_rep2=y_rep2,
   ngames_train=ngames_train_BundesLiga, 
  theta1_hat=theta1_hat_BundesLiga, 
  theta2_hat=theta2_hat_BundesLiga,
  score1=score1_BundesLiga, score2=score2_BundesLiga, M=M)


  
  
### Figure 5: Posterior predictions ###
## (Section 4.4)

posterior_pred=function(M, ngames_test, previsioni1, previsioni2, 
                        team1_prev, team2_prev, teams,
                        gol_vero1, gol_vero2, p){


  
  posterior_prop1<-table(subset(previsioni1[,p], previsioni1[,p]<15))
  posterior_prop2<-table(subset(previsioni2[,p], previsioni2[,p]<15))
  

teamaa=teams[team1_prev[p]]
teamab=teams[team2_prev[p]]

x_min=y_min=min(length(posterior_prop1), length(posterior_prop2))

counts_mix<-matrix(0, min(length(posterior_prop1), length(posterior_prop2)), 
                   min(length(posterior_prop1), length(posterior_prop2)))

for (j in 1: min(length(posterior_prop1), length(posterior_prop2))){
  for (t in 1: min(length(posterior_prop1), length(posterior_prop2))){
    counts_mix[j,t]<-posterior_prop1[j]*posterior_prop2[t]
  }}


x <- seq(0,5, length.out=6)
y <- seq(0,5, length.out=6)
data <- expand.grid(Home=x, Away=y)
data$Prob=as.double(counts_mix[1:6, 1:6]/(M*M))


# To change the color of the gradation :

ggplot(data, aes(Home, Away, z= Prob)) + geom_tile(aes(fill = Prob)) + 
  theme_bw() + 
  scale_fill_gradient(low="white", high="black") +
  geom_rect(aes(xmin = as.numeric(as.vector(gol_vero1))[p]-0.5, 
    xmax = as.numeric(as.vector(gol_vero1))[p]+0.5, 
                ymin = as.numeric(as.vector(gol_vero2))[p]-0.5, 
    ymax =as.numeric(as.vector(gol_vero2))[p]+0.5),
            fill = "transparent", color = "red", size = 1.5)+
  labs(title=paste(  teams[team1_prev[p]],"-", teams[team2_prev[p]]))
ggsave(file=paste(teams[team1_prev[p]],"-", teams[team2_prev[p]], "Heatmap.pdf", sep=""), width=6, height=6)

  
}


 posterior_pred(M, ngames_test_serieA, previsioni1_serieA, 
               previsioni2_serieA, team1_prev_serieA, 
               team2_prev_serieA, teams_serieA, 
               as.vector(gol_vero1_serieA), 
               as.vector(gol_vero2_serieA), p = 289)

 posterior_pred(M, ngames_test_Liga, previsioni1_Liga, 
               previsioni2_Liga, team1_prev_Liga, 
               team2_prev_Liga, teams_Liga, 
               gol_vero1_Liga, gol_vero2_Liga, p = 327 )
 
 posterior_pred(M, ngames_test_PL, previsioni1_PL, 
              previsioni2_PL, team1_prev_PL, 
              team2_prev_PL, teams_PL, 
              gol_vero1_PL, gol_vero2_PL, p = 300 )
 
 posterior_pred(M, ngames_test_BundesLiga, previsioni1_BundesLiga, 
              previsioni2_BundesLiga, team1_prev_BundesLiga, 
              team2_prev_BundesLiga, teams_BundesLiga, 
              gol_vero1_BundesLiga, gol_vero2_BundesLiga, p = 300 )
 
 
 
 
 
 
###Figure 6:  Rank plot ###
 ## (Section 4.4),
 
 obs_ita <- c(91, 86, 87, 60, 70, 62, 63, 53, 36, 72,46,48,43,45,32, 41,47,34,26, 18)
 obs_ita <- sort(obs_ita, decreasing = TRUE)
 class_ita <- c( "Juventus", "Roma",  "Napoli", "Atalanta", "Lazio","Milan" ,      "Inter", "Fiorentina", "Torino","Sassuolo", "Sampdoria", "Cagliari", "Udinese", 
   "Chievo" , "Bologna", "Genoa", "Crotone" , "Empoli",               
 "Palermo" , "Pescara")  
 
 obs_spa  <- c(90, 93, 78, 72, 63, 67, 46, 64, 39, 46, 45, 54, 55, 56, 35, 36,39,31, 20, 22 )
 obs_spa <- sort(obs_spa, decreasing = TRUE)
 class_spa <- c( "Real Madrid", "Barcelona", "Ath Madrid" ,  "Sevilla" , "Villarreal", "Sociedad", "Ath Bilbao",  "Espanol" , "Alaves", "Eibar", "Malaga", "Valencia" ,"Celta" , "Las Palmas", "Betis" ,  "La Coruna"  ,  "Leganes" , "Sp Gijon"  ,
   "Osasuna" , "Granada")
 
 obs_ger <- c(82, 64, 45, 41, 43, 37, 67, 37, 49, 62, 48, 38, 42, 49, 32, 45, 38, 25)
 obs_ger <- sort (obs_ger, decreasing = TRUE)
 class_ger <- c("Bayern Munich", "RB Leipzig" , "Dortmund"  ,  "Hoffenheim" ,  
   "FC Koln", "Hertha",  "Freiburg",  "Werder Bremen", "M'gladbach"  , 
   "Schalke 04" ,"Ein Frankfurt" ,  "Leverkusen" , 
   "Augsburg" , "Hamburg",  "Mainz", "Wolfsburg",  "Ingolstadt","Darmstadt")
 
 obs_eng <- c(78, 75, 93, 86, 76, 69, 46, 44, 61, 45, 41, 44, 41, 40, 45,45, 24,  34, 28, 40)
 obs_eng <- sort(obs_eng, decreasing = TRUE)
 class_eng <- c("Chelsea"  , "Tottenham",  "Man City" , "Liverpool",
   "Arsenal" , "Man United", "Everton" , "Southampton" , "Bournemouth", 
   "West Brom", "West Ham" ,  "Leicester" , "Stoke" ,  "Crystal Palace", "Swansea",
   "Burnley", "Watford" , "Hull",          
          "Middlesbrough" ,"Sunderland")
 
rank_plot<- function(string, league, class_names, obs, previsioni1, previsioni2, ngames_test, teams, team1_prev, team2_prev){
  
  conta_punti=matrix(0, length(previsioni1[,1]), length(teams))
  
  for (t in 1:M){
    
    for (n in 1:ngames_test){
      if (previsioni1[t,n]>previsioni2[t,n]){
        conta_punti[t,team1_prev[n]]=conta_punti[t,team1_prev[n]]+3
        conta_punti[t,team2_prev[n]]=conta_punti[t,team2_prev[n]]
      }else if(previsioni1[t,n]==previsioni2[t,n]){
        
        conta_punti[t,team1_prev[n]]=conta_punti[t,team1_prev[n]]+1
        conta_punti[t,team2_prev[n]]=conta_punti[t,team2_prev[n]]+1
        
      }else if(previsioni1[t,n]<previsioni2[t,n]){
        
        conta_punti[t,team1_prev[n]]=conta_punti[t,team1_prev[n]]
        conta_punti[t,team2_prev[n]]=conta_punti[t,team2_prev[n]]+3
        
      }
      
    }
    
  }
  
  expected_point=apply(conta_punti,2,median)
  points_25=apply(conta_punti,2,function(x) quantile(x, 0.25))
  points_75=apply(conta_punti,2,function(x) quantile(x, 0.75))
  sd_expected=apply(conta_punti,2,sd)
  cbind(teams[unique(team1_prev)], expected_point[unique(team1_prev)], 
    points_25[unique(team1_prev)], points_75[unique(team1_prev)] )
  class=sort.int(expected_point[unique(team1_prev)], index.return=TRUE, 
    decreasing=TRUE)
  
  rank_bar=cbind(teams[unique(team1_prev)][class$ix], class$x, 
    points_25[unique(team1_prev)][class$ix], 
    points_75[unique(team1_prev)][class$ix]  )
  
  rank_frame=data.frame(
    squadre=rank_bar[,1],
    mid=as.numeric(as.vector(rank_bar[,2])),
    lo=as.numeric(as.vector(rank_bar[,3])),
    hi=as.numeric(as.vector(rank_bar[,4])),
    obs=obs[  match(  rank_bar[,1], class_names) ]
  )
  
  rank_frame$squadre=factor(rank_frame$squadre, levels=rank_bar[,1])
  
  
  
  ggplot()+
    geom_ribbon(aes(x=squadre, ymin=lo, ymax=hi, group=1),
      data=rank_frame,
      fill = color_scheme_get("gray")[[2]]
    )+
    geom_line(aes(x=squadre, y= mid, group=1),
      data=rank_frame,
      fill = color_scheme_get("blue")[[2]]
    )+
    geom_point(aes(x=squadre, y=obs),
      data=rank_frame)+
    scale_color_manual(values = c(color_scheme_get("blue")[[2]], 
      color_scheme_get("red")[[2]]))+
    theme(axis.text.x = element_text(angle = 90, hjust = 1))+
    labs(x="Teams", y="Points")
  
  ggsave(file=paste("RankPlot", string,".pdf", sep=""), width=6, height=6)
  
  conta_max=c()
  conta_second=c()
  conta_third=c()
  conta_18=c()
  conta_19=c()
  conta_last=c()
  
  if (string=="Ger"){
    last1<-16
    last2<-17
    last3<-18
  } else{
    last1<-18
    last2<-19
    last3<-20
  }
  
  for(t in 1:M){
    conta_max[t]=which.max(conta_punti[t,])
    conta_second[t]=sort.int(conta_punti[t,], index.return = TRUE, decreasing = TRUE)$ix[2]
    conta_third[t]=sort.int(conta_punti[t,], index.return = TRUE, decreasing = TRUE)$ix[3]
    conta_18[t]=sort.int(conta_punti[t,], index.return = TRUE, decreasing = TRUE)$ix[last1]
    conta_19[t]=sort.int(conta_punti[t,], index.return = TRUE, decreasing = TRUE)$ix[last2]
    conta_last[t]=sort.int(conta_punti[t,], index.return = TRUE, decreasing = TRUE)$ix[last3]
    
  }
  
  conta_max_frame=as.data.frame(table(conta_max))
  sort_conta_max=sort.int( conta_max_frame$Freq, index.return = TRUE, decreasing=TRUE  )
  team_conta_max=conta_max_frame$conta_max[sort_conta_max$ix]
  
  conta_second_frame=as.data.frame(table(conta_second))
  sort_conta_second=sort.int( conta_second_frame$Freq, index.return = TRUE, decreasing=TRUE  )
  team_conta_second=conta_second_frame$conta_second[sort_conta_second$ix]
  
  conta_third_frame=as.data.frame(table(conta_third))
  sort_conta_third=sort.int( conta_third_frame$Freq, index.return = TRUE, decreasing=TRUE  )
  team_conta_third=conta_third_frame$conta_third[sort_conta_third$ix]
  
  conta_18_frame=as.data.frame(table(conta_18))
  sort_conta_18=sort.int( conta_18_frame$Freq, index.return = TRUE, decreasing=TRUE  )
  team_conta_18=conta_18_frame$conta_18[sort_conta_18$ix]
  
  conta_19_frame=as.data.frame(table(conta_19))
  sort_conta_19=sort.int( conta_19_frame$Freq, index.return = TRUE, decreasing=TRUE  )
  team_conta_19=conta_19_frame$conta_19[sort_conta_19$ix]
  
  conta_last_frame=as.data.frame(table(conta_last))
  sort_conta_last=sort.int( conta_last_frame$Freq, index.return = TRUE, decreasing=TRUE  )
  team_conta_last=conta_last_frame$conta_last[sort_conta_last$ix]
  
  
  
  #probabilità di vincere il campionato, secondo e terzo
  
  posterior_prob_win=cbind(teams[as.numeric(as.vector(team_conta_max))], sort_conta_max$x/M )
  posterior_prob_second=cbind(teams[as.numeric(as.vector(team_conta_second))], sort_conta_second$x/M )
  posterior_prob_third=cbind(teams[as.numeric(as.vector(team_conta_third))], sort_conta_third$x/M )
  posterior_prob_18=cbind(teams[as.numeric(as.vector(team_conta_18))], sort_conta_18$x/M )
  posterior_prob_19=cbind(teams[as.numeric(as.vector(team_conta_19))], sort_conta_19$x/M )
  posterior_prob_20=cbind(teams[as.numeric(as.vector(team_conta_last))], sort_conta_last$x/M )
  
  
  return(list(posterior_prob_win = posterior_prob_win, 
    posterior_prob_second=posterior_prob_second,
    posterior_prob_third=posterior_prob_third,
    posterior_prob_18=posterior_prob_18, 
    posterior_prob_19=posterior_prob_19, 
    posterior_prob_20=posterior_prob_20))
  
} 

 ita_rank <- rank_plot("Ita", serieA, class_ita, obs_ita, previsioni1_serieA, previsioni2_serieA, ngames_test_serieA, teams_serieA,
  team1_prev_serieA, team2_prev_serieA)

 eng_rank <- rank_plot("Eng", PL, class_eng, obs_eng, 
   previsioni1_PL, 
   previsioni2_PL, ngames_test_PL, teams_PL,
  team1_prev_PL, team2_prev_PL)

 spa_rank <- rank_plot("Spa", Liga, class_spa, obs_spa, previsioni1_Liga,previsioni2_Liga, ngames_test_Liga, teams_Liga,
  team1_prev_Liga, team2_prev_Liga)
 
 ger_rank <- rank_plot("Ger", BundesLiga, class_ger, obs_ger, 
   previsioni1_BundesLiga, 
   previsioni2_BundesLiga, ngames_test_BundesLiga,
   teams_BundesLiga, team1_prev_BundesLiga, 
   team2_prev_BundesLiga)
 
 

 
#############################################################################
##ANALISI MODELLI: INDICATORI, STATISTICHE, PLOT e TABELLE
###########################################################################
 
 
### Table 1 ###
## (Section 4.4)
 
 short_teams_spa=c("Real Madrid", "Barcelona", "Ath Madrid", "Sp Gijon", "Osasuna", "Granada")
 positions_spa=c(1,2,3,18,19,20)
 points_spa=c(93,90,78, 31,22,20)
 
 short_teams_ita=c("Juventus", "Roma", "Napoli", "Empoli", "Palermo", "Pescara")
 positions_ita=c(1,2,3,18,19,20)
 points_ita=c(91,87,86, 32,26,18)
 
 short_teams_ger=c("Bayern Munich", "RB Leipzig", "Dortmund", "Wolfsburg", "Ingolstadt", "Darmstadt")
 positions_ger=c(1,2,3,18,19,20)
 points_ger=c(82,67,64, 37,32,25)
 
 short_teams_eng=c("Chelsea", "Tottenham", "Man City", "Hull", "Middlesbrough", "Sunderland")
 positions_eng=c(1,2,3,18,19,20)
 points_eng=c(93,86,78, 34,28,24)
 
 table_function <- function(rank, short_teams, positions, points){
 
 tab_3places=rbind(
   c(short_teams[1], rank$posterior_prob_win[rank$posterior_prob_win[,1]==short_teams[1],2], 
     rank$posterior_prob_second[  rank$posterior_prob_second[,1]==short_teams[1],2],
     rank$posterior_prob_third[  rank$posterior_prob_third[,1]==short_teams[1],2],positions[1],points[1]),
   
   c(short_teams[2], rank$posterior_prob_win[  rank$posterior_prob_win[,1]==short_teams[2],2], 
     rank$posterior_prob_second[  rank$posterior_prob_second[,1]==short_teams[2],2],
     rank$posterior_prob_third[  rank$posterior_prob_third[,1]==short_teams[2],2],positions[2],points[2]),
   
   c(short_teams[3], rank$posterior_prob_win[  rank$posterior_prob_win[,1]==short_teams[3],2], 
     rank$posterior_prob_second[  rank$posterior_prob_second[,1]==short_teams[3],2],
     rank$posterior_prob_third[  rank$posterior_prob_third[,1]==short_teams[3],2],positions[3],points[3]))
   
   
 
 
 tab_last3places=rbind(
   c(short_teams[4],  rank$posterior_prob_18[   rank$posterior_prob_18[,1]==short_teams[4],2], 
     rank$posterior_prob_19[   rank$posterior_prob_19[,1]==short_teams[4],2],
     rank$posterior_prob_20[   rank$posterior_prob_20[,1]==short_teams[4],2],positions[4],points[4]),
   
   c(short_teams[5],  rank$posterior_prob_18[   rank$posterior_prob_18[,1]==short_teams[5],2], 
     rank$posterior_prob_19[   rank$posterior_prob_19[,1]==short_teams[5],2],
     rank$posterior_prob_20[   rank$posterior_prob_20[,1]==short_teams[5],2],positions[5],points[5]),
   
   c(short_teams[6],  rank$posterior_prob_18[   rank$posterior_prob_18[,1]==short_teams[6],2], 
     rank$posterior_prob_19[   rank$posterior_prob_19[,1]==short_teams[6],2],
     rank$posterior_prob_20[   rank$posterior_prob_20[,1]==short_teams[6],2],positions[6],points[6]))
 return(list(tab_3places=tab_3places, tab_last3places=tab_last3places))
 }
 
 ger_table <- table_function(ger_rank, short_teams_ger, positions_ger, points_ger)
 eng_table <- table_function(eng_rank, short_teams_eng, positions_eng, points_eng)
 spa_table <- table_function(spa_rank, short_teams_spa, positions_spa, points_spa)
 ita_table <- table_function(ita_rank, short_teams_ita, positions_ita, points_ita)

 
 
 library(xtable)
 
 xtable(ger_table$tab_3places)
 xtable(ger_table$tab_last3places)
 
 xtable(eng_table$tab_3places)
 xtable(eng_table$tab_last3places) 
 
 
 xtable(spa_table$tab_3places)
 xtable(spa_table$tab_last3places)
 
 xtable(ita_table$tab_3places)
 xtable(ita_table$tab_last3places)
 
 
 
 




